# MAXEDR10 - MAX ERP 10

Sistema SaaS de Gestão Empresarial (Mini ERP) com módulo financeiro e contratos com TAGs

## 🚀 Tecnologias

- **Backend:** PHP 8+ com PDO
- **Banco de Dados:** MySQL
- **Frontend:** HTML5, CSS3, JavaScript (ES6+)
- **Framework CSS:** Bootstrap 5
- **Arquitetura:** API-First (REST)

## 📋 Funcionalidades

### Módulo Financeiro
- ✅ Lançamentos financeiros (Entradas e Saídas)
- ✅ Categorias financeiras
- ✅ Contas a pagar e receber
- ✅ Dashboard com gráficos
- ✅ Relatórios financeiros

### Módulo de Clientes
- ✅ Cadastro completo de clientes
- ✅ Histórico de contratos por cliente

### Módulo de Contratos
- ✅ Modelos de contrato com TAGs
- ✅ Geração automática de contratos
- ✅ Substituição dinâmica de TAGs
- ✅ Histórico de contratos gerados

## 🛠️ Instalação

### 1. Requisitos

- PHP 8.0 ou superior
- MySQL 5.7 ou superior
- Servidor Web (Apache/Nginx)
- Extensões PHP: PDO, pdo_mysql

### 2. Configuração do Banco de Dados

```bash
# Criar banco de dados
mysql -u root -p
CREATE DATABASE maxedr10 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
exit;

# Importar schema
mysql -u root -p maxedr10 < database/schema.sql
```

### 3. Configuração do Sistema

Edite o arquivo `config/config.php` e ajuste as credenciais do banco:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'maxedr10');
define('DB_USER', 'root');
define('DB_PASS', ''); // Sua senha do MySQL
```

Ajuste também as URLs base:

```php
define('BASE_URL', 'http://localhost/maxedr10/public');
define('API_URL', 'http://localhost/maxedr10/api');
```

### 4. Permissões

```bash
# Linux/Mac
chmod -R 755 maxedr10/
```

### 5. Acessar o Sistema

Acesse: `http://localhost/maxedr10/public/index.php`

**Credenciais Padrão:**
- **E-mail:** admin@demo.com
- **Senha:** 123456

## 📁 Estrutura de Pastas

```
maxedr10/
├── api/                    # APIs REST (JSON)
│   ├── auth/              # Autenticação
│   ├── lancamentos/       # Lançamentos financeiros
│   ├── categorias/        # Categorias
│   ├── contas/            # Contas a pagar/receber
│   ├── clientes/          # Clientes
│   ├── contratos/         # Contratos
│   └── dashboard/         # Dashboard
├── config/                # Configurações
│   └── config.php        # Config principal
├── database/             # Banco de dados
│   └── schema.sql        # Schema das tabelas
├── public/               # Frontend (páginas)
│   ├── assets/          # CSS, JS, imagens
│   ├── includes/        # Header, Sidebar, Footer
│   ├── index.php        # Login
│   ├── dashboard.php    # Dashboard
│   ├── lancamentos.php  # Lançamentos
│   ├── categorias.php   # Categorias
│   ├── contas.php       # Contas
│   ├── clientes.php     # Clientes
│   ├── contratos_modelos.php  # Modelos
│   └── contratos_gerar.php    # Gerar contratos
└── src/                  # Classes PHP
    ├── Database/        # Conexão PDO
    ├── Models/          # Models (Usuario, Cliente, etc)
    └── autoload.php     # Autoloader

```

## 🎨 Design

- **Cores:** Azul neutro (#4a90e2) com gradientes
- **Layout:** Responsivo (mobile-first)
- **Sidebar:** Retrátil em dispositivos móveis
- **Cards:** Com efeitos de sombra e hover
- **Tabelas:** Responsivas com scroll horizontal

## 📊 Módulo de Contratos - TAGs Disponíveis

As seguintes TAGs podem ser usadas nos modelos de contrato:

- `{{nome}}` - Nome do cliente
- `{{cpf}}` - CPF (pessoa física)
- `{{cnpj}}` - CNPJ (pessoa jurídica)
- `{{cpf_cnpj}}` - CPF ou CNPJ
- `{{endereco}}` - Endereço completo
- `{{cidade}}` - Cidade
- `{{estado}}` - Estado (UF)
- `{{telefone}}` - Telefone
- `{{email}}` - E-mail
- `{{data_atual}}` - Data atual
- `{{valor}}` - Valor do contrato
- `{{descricao_servico}}` - Descrição do serviço
- `{{data_validade}}` - Data de validade

## 🔒 Segurança

- ✅ Senhas criptografadas com `password_hash()`
- ✅ Proteção contra SQL Injection (PDO Prepared Statements)
- ✅ Sessões PHP para autenticação
- ✅ Validação de dados no backend
- ✅ Soft delete para preservar dados

## 🌐 API Endpoints

### Autenticação
- `POST /api/auth/login.php` - Login
- `POST /api/auth/logout.php` - Logout
- `GET /api/auth/me.php` - Usuário autenticado

### Lançamentos
- `GET /api/lancamentos/index.php` - Listar
- `POST /api/lancamentos/index.php` - Criar
- `PUT /api/lancamentos/index.php?id=X` - Atualizar
- `DELETE /api/lancamentos/index.php?id=X` - Deletar

### Categorias
- `GET /api/categorias/index.php` - Listar
- `POST /api/categorias/index.php` - Criar
- `PUT /api/categorias/index.php?id=X` - Atualizar
- `DELETE /api/categorias/index.php?id=X` - Deletar

### Contas
- `GET /api/contas/index.php` - Listar
- `POST /api/contas/index.php` - Criar
- `PUT /api/contas/index.php?id=X` - Atualizar
- `DELETE /api/contas/index.php?id=X` - Deletar

### Clientes
- `GET /api/clientes/index.php` - Listar
- `GET /api/clientes/index.php?id=X` - Buscar
- `POST /api/clientes/index.php` - Criar
- `PUT /api/clientes/index.php?id=X` - Atualizar
- `DELETE /api/clientes/index.php?id=X` - Deletar

### Contratos
- `GET /api/contratos/modelos.php` - Listar modelos
- `POST /api/contratos/modelos.php` - Criar modelo
- `PUT /api/contratos/modelos.php?id=X` - Atualizar modelo
- `DELETE /api/contratos/modelos.php?id=X` - Deletar modelo
- `POST /api/contratos/gerar.php` - Gerar contrato

### Dashboard
- `GET /api/dashboard/resumo.php` - Resumo financeiro

## 🔄 Próximas Funcionalidades (Roadmap)

- [ ] Geração de PDF para contratos
- [ ] Relatórios em PDF/Excel
- [ ] Envio de e-mails
- [ ] Notificações de vencimento
- [ ] Multi-empresas (SaaS completo)
- [ ] Permissões de usuário
- [ ] Backup automático
- [ ] API REST com autenticação JWT

## 📝 Licença

Este é um projeto de demonstração.

## 👨‍💻 Desenvolvedor

Desenvolvido como template de sistema ERP moderno.

## 📞 Suporte

Para dúvidas e sugestões, entre em contato.

---

**MAXEDR10** - Gestão Empresarial Moderna e Eficiente
