<?php
/**
 * MAXEDR10 - MAX ERP 10
 * API de Categorias Financeiras
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../src/autoload.php';

use Maxedr10\Models\Categoria;

setJsonHeaders();

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$user = getAuthUser();
$empresaId = $user['empresa_id'];

try {
    $categoriaModel = new Categoria();
    
    if ($method === 'GET') {
        $tipo = $_GET['tipo'] ?? null;
        $categorias = $categoriaModel->listar($empresaId, $tipo);
        
        echo json_encode(['success' => true, 'data' => $categorias]);
    }
    
    elseif ($method === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (empty($data['nome'])) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'Nome é obrigatório']);
            exit;
        }
        
        $data['empresa_id'] = $empresaId;
        $id = $categoriaModel->criar($data);
        
        if ($id) {
            echo json_encode(['success' => true, 'message' => 'Categoria criada com sucesso', 'id' => $id]);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao criar categoria']);
        }
    }
    
    elseif ($method === 'PUT') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID não informado']);
            exit;
        }
        
        $data = json_decode(file_get_contents('php://input'), true);
        
        if ($categoriaModel->atualizar($id, $empresaId, $data)) {
            echo json_encode(['success' => true, 'message' => 'Categoria atualizada com sucesso']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao atualizar categoria']);
        }
    }
    
    elseif ($method === 'DELETE') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID não informado']);
            exit;
        }
        
        if ($categoriaModel->deletar($id, $empresaId)) {
            echo json_encode(['success' => true, 'message' => 'Categoria deletada com sucesso']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao deletar categoria']);
        }
    }
    
    else {
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Erro no servidor: ' . $e->getMessage()]);
}
