<?php
/**
 * MAXEDR10 - MAX ERP 10
 * API de Contas a Pagar/Receber
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../src/autoload.php';

use Maxedr10\Models\Conta;

setJsonHeaders();

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$user = getAuthUser();
$empresaId = $user['empresa_id'];

try {
    $contaModel = new Conta();
    
    // Atualizar status de contas atrasadas
    $contaModel->atualizarAtrasadas($empresaId);
    
    if ($method === 'GET') {
        $filtros = [
            'tipo' => $_GET['tipo'] ?? null,
            'status' => $_GET['status'] ?? null,
            'data_vencimento_inicio' => $_GET['data_vencimento_inicio'] ?? null,
            'data_vencimento_fim' => $_GET['data_vencimento_fim'] ?? null
        ];
        
        $contas = $contaModel->listar($empresaId, $filtros);
        echo json_encode(['success' => true, 'data' => $contas]);
    }
    
    elseif ($method === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (empty($data['tipo']) || empty($data['descricao']) || empty($data['valor']) || empty($data['data_vencimento'])) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'Campos obrigatórios: tipo, descricao, valor, data_vencimento']);
            exit;
        }
        
        $data['empresa_id'] = $empresaId;
        $id = $contaModel->criar($data);
        
        if ($id) {
            echo json_encode(['success' => true, 'message' => 'Conta criada com sucesso', 'id' => $id]);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao criar conta']);
        }
    }
    
    elseif ($method === 'PUT') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID não informado']);
            exit;
        }
        
        $data = json_decode(file_get_contents('php://input'), true);
        
        if ($contaModel->atualizar($id, $empresaId, $data)) {
            echo json_encode(['success' => true, 'message' => 'Conta atualizada com sucesso']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao atualizar conta']);
        }
    }
    
    elseif ($method === 'DELETE') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID não informado']);
            exit;
        }
        
        if ($contaModel->deletar($id, $empresaId)) {
            echo json_encode(['success' => true, 'message' => 'Conta deletada com sucesso']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao deletar conta']);
        }
    }
    
    else {
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Erro no servidor: ' . $e->getMessage()]);
}
