<?php
/**
 * MAXEDR10 - MAX ERP 10
 * API de Contratos - Geração
 * 
 * POST /api/contratos/gerar.php - Gera um contrato para um cliente
 * GET /api/contratos/gerar.php?id=X - Busca um contrato gerado
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../src/autoload.php';

use Maxedr10\Models\Contrato;

setJsonHeaders();

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$user = getAuthUser();
$empresaId = $user['empresa_id'];

try {
    $contratoModel = new Contrato();
    
    // ========== POST - Gerar Contrato ==========
    if ($method === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (empty($data['cliente_id']) || empty($data['modelo_id'])) {
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'message' => 'cliente_id e modelo_id são obrigatórios'
            ]);
            exit;
        }
        
        // Dados extras (opcionais)
        $dadosExtras = [
            'valor' => $data['valor'] ?? '',
            'descricao_servico' => $data['descricao_servico'] ?? '',
            'data_validade' => $data['data_validade'] ?? ''
        ];
        
        $resultado = $contratoModel->gerarContrato(
            $empresaId,
            $data['cliente_id'],
            $data['modelo_id'],
            $dadosExtras
        );
        
        if ($resultado['success']) {
            echo json_encode($resultado);
        } else {
            http_response_code(400);
            echo json_encode($resultado);
        }
    }
    
    // ========== GET - Buscar Contrato Gerado ==========
    elseif ($method === 'GET') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'message' => 'ID do contrato não informado'
            ]);
            exit;
        }
        
        $contrato = $contratoModel->buscarGeradoPorId($id, $empresaId);
        
        if ($contrato) {
            echo json_encode([
                'success' => true,
                'data' => $contrato
            ]);
        } else {
            http_response_code(404);
            echo json_encode([
                'success' => false,
                'message' => 'Contrato não encontrado'
            ]);
        }
    }
    
    else {
        http_response_code(405);
        echo json_encode([
            'success' => false,
            'message' => 'Método não permitido'
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro no servidor: ' . $e->getMessage()
    ]);
}
