<?php
/**
 * MAXEDR10 - MAX ERP 10
 * API de Contratos - Modelos
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../src/autoload.php';

use Maxedr10\Models\Contrato;

setJsonHeaders();

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$user = getAuthUser();
$empresaId = $user['empresa_id'];

try {
    $contratoModel = new Contrato();
    
    if ($method === 'GET') {
        $id = $_GET['id'] ?? null;
        
        if ($id) {
            $modelo = $contratoModel->buscarModeloPorId($id, $empresaId);
            
            if ($modelo) {
                echo json_encode(['success' => true, 'data' => $modelo]);
            } else {
                http_response_code(404);
                echo json_encode(['success' => false, 'message' => 'Modelo não encontrado']);
            }
        } else {
            $modelos = $contratoModel->listarModelos($empresaId);
            echo json_encode(['success' => true, 'data' => $modelos]);
        }
    }
    
    elseif ($method === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (empty($data['nome']) || empty($data['conteudo_html'])) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'Nome e conteúdo HTML são obrigatórios']);
            exit;
        }
        
        $data['empresa_id'] = $empresaId;
        $id = $contratoModel->criarModelo($data);
        
        if ($id) {
            echo json_encode(['success' => true, 'message' => 'Modelo criado com sucesso', 'id' => $id]);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao criar modelo']);
        }
    }
    
    elseif ($method === 'PUT') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID não informado']);
            exit;
        }
        
        $data = json_decode(file_get_contents('php://input'), true);
        
        if ($contratoModel->atualizarModelo($id, $empresaId, $data)) {
            echo json_encode(['success' => true, 'message' => 'Modelo atualizado com sucesso']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao atualizar modelo']);
        }
    }
    
    elseif ($method === 'DELETE') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID não informado']);
            exit;
        }
        
        if ($contratoModel->deletarModelo($id, $empresaId)) {
            echo json_encode(['success' => true, 'message' => 'Modelo deletado com sucesso']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao deletar modelo']);
        }
    }
    
    else {
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Erro no servidor: ' . $e->getMessage()]);
}
