<?php
/**
 * MAXEDR10 - MAX ERP 10
 * API de Dashboard
 * 
 * GET /api/dashboard/resumo.php - Retorna resumo financeiro do mês e últimos 12 meses
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../src/autoload.php';

use Maxedr10\Models\Lancamento;

setJsonHeaders();

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user = getAuthUser();
$empresaId = $user['empresa_id'];

try {
    $lancamentoModel = new Lancamento();
    
    // Totais do mês atual
    $mesAtual = date('Y-m-01');
    $proximoMes = date('Y-m-01', strtotime('+1 month'));
    
    $totaisMes = $lancamentoModel->totaisPorTipo($empresaId, $mesAtual, $proximoMes);
    
    // Faturamento dos últimos 12 meses
    $faturamentoMensal = $lancamentoModel->faturamentoMensal($empresaId, 12);
    
    // Formatar dados para o gráfico
    $meses = [];
    $entradas = [];
    $saidas = [];
    
    foreach ($faturamentoMensal as $row) {
        // Converter YYYY-MM para nome do mês
        $data = $row['mes'] . '-01';
        $mesNome = strftime('%b/%y', strtotime($data));
        
        $meses[] = $mesNome;
        $entradas[] = (float) $row['entradas'];
        $saidas[] = (float) $row['saidas'];
    }
    
    echo json_encode([
        'success' => true,
        'resumo_mes' => [
            'entradas' => $totaisMes['entrada'],
            'saidas' => $totaisMes['saida'],
            'saldo' => $totaisMes['saldo']
        ],
        'grafico' => [
            'meses' => $meses,
            'entradas' => $entradas,
            'saidas' => $saidas
        ]
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro no servidor: ' . $e->getMessage()
    ]);
}
