-- MAXEDR10 - MAX ERP 10
-- Schema do Banco de Dados
-- Criado em: 2025-12-04

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

-- ====================================
-- TABELA: empresas
-- ====================================
CREATE TABLE IF NOT EXISTS `empresas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(200) NOT NULL,
  `cnpj` varchar(20) DEFAULT NULL,
  `telefone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `endereco` varchar(255) DEFAULT NULL,
  `cidade` varchar(100) DEFAULT NULL,
  `estado` char(2) DEFAULT NULL,
  `cep` varchar(10) DEFAULT NULL,
  `ativo` tinyint(1) DEFAULT 1,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_cnpj` (`cnpj`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir empresa padrão
INSERT INTO `empresas` (`id`, `nome`, `cnpj`, `email`, `ativo`) VALUES
(1, 'Empresa Demo', '00.000.000/0001-00', 'contato@empresademo.com.br', 1);

-- ====================================
-- TABELA: usuarios
-- ====================================
CREATE TABLE IF NOT EXISTS `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empresa_id` int(11) NOT NULL,
  `nome` varchar(200) NOT NULL,
  `email` varchar(100) NOT NULL,
  `senha` varchar(255) NOT NULL,
  `nivel` enum('admin','usuario') DEFAULT 'usuario',
  `ativo` tinyint(1) DEFAULT 1,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_email` (`email`),
  KEY `fk_usuario_empresa` (`empresa_id`),
  CONSTRAINT `fk_usuario_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir usuário padrão: admin@demo.com / senha: 123456
-- Senha criptografada: password_hash('123456', PASSWORD_DEFAULT)
INSERT INTO `usuarios` (`id`, `empresa_id`, `nome`, `email`, `senha`, `nivel`, `ativo`) VALUES
(1, 1, 'Administrador', 'admin@demo.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1);

-- ====================================
-- TABELA: clientes
-- ====================================
CREATE TABLE IF NOT EXISTS `clientes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empresa_id` int(11) NOT NULL,
  `nome` varchar(200) NOT NULL,
  `cpf_cnpj` varchar(20) DEFAULT NULL,
  `tipo` enum('fisica','juridica') DEFAULT 'fisica',
  `telefone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `endereco` varchar(255) DEFAULT NULL,
  `numero` varchar(20) DEFAULT NULL,
  `complemento` varchar(100) DEFAULT NULL,
  `bairro` varchar(100) DEFAULT NULL,
  `cidade` varchar(100) DEFAULT NULL,
  `estado` char(2) DEFAULT NULL,
  `cep` varchar(10) DEFAULT NULL,
  `observacoes` text DEFAULT NULL,
  `ativo` tinyint(1) DEFAULT 1,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_cliente_empresa` (`empresa_id`),
  KEY `idx_cpf_cnpj` (`cpf_cnpj`),
  KEY `idx_nome` (`nome`),
  CONSTRAINT `fk_cliente_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ====================================
-- TABELA: categorias_financeiras
-- ====================================
CREATE TABLE IF NOT EXISTS `categorias_financeiras` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empresa_id` int(11) NOT NULL,
  `nome` varchar(100) NOT NULL,
  `tipo` enum('entrada','saida','ambos') DEFAULT 'ambos',
  `cor` varchar(7) DEFAULT '#3498db',
  `ativo` tinyint(1) DEFAULT 1,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_categoria_empresa` (`empresa_id`),
  CONSTRAINT `fk_categoria_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir categorias padrão
INSERT INTO `categorias_financeiras` (`empresa_id`, `nome`, `tipo`, `cor`) VALUES
(1, 'Vendas', 'entrada', '#27ae60'),
(1, 'Serviços', 'entrada', '#2ecc71'),
(1, 'Marketing', 'saida', '#e74c3c'),
(1, 'Aluguel', 'saida', '#c0392b'),
(1, 'Funcionários', 'saida', '#e67e22'),
(1, 'Ferramentas', 'saida', '#f39c12'),
(1, 'Impostos', 'saida', '#d35400'),
(1, 'Outros', 'ambos', '#95a5a6');

-- ====================================
-- TABELA: lancamentos_financeiros
-- ====================================
CREATE TABLE IF NOT EXISTS `lancamentos_financeiros` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empresa_id` int(11) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `categoria_id` int(11) DEFAULT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  `data` date NOT NULL,
  `tipo` enum('entrada','saida') NOT NULL,
  `descricao` varchar(255) NOT NULL,
  `valor` decimal(15,2) NOT NULL,
  `forma_pagamento` enum('dinheiro','pix','cartao_credito','cartao_debito','boleto','transferencia','outros') DEFAULT 'dinheiro',
  `observacoes` text DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_lancamento_empresa` (`empresa_id`),
  KEY `fk_lancamento_usuario` (`usuario_id`),
  KEY `fk_lancamento_categoria` (`categoria_id`),
  KEY `fk_lancamento_cliente` (`cliente_id`),
  KEY `idx_data` (`data`),
  KEY `idx_tipo` (`tipo`),
  CONSTRAINT `fk_lancamento_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lancamento_usuario` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lancamento_categoria` FOREIGN KEY (`categoria_id`) REFERENCES `categorias_financeiras` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_lancamento_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ====================================
-- TABELA: contas
-- ====================================
CREATE TABLE IF NOT EXISTS `contas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empresa_id` int(11) NOT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  `tipo` enum('pagar','receber') NOT NULL,
  `descricao` varchar(255) NOT NULL,
  `valor` decimal(15,2) NOT NULL,
  `data_vencimento` date NOT NULL,
  `data_pagamento` date DEFAULT NULL,
  `status` enum('pendente','pago','atrasado','cancelado') DEFAULT 'pendente',
  `observacoes` text DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_conta_empresa` (`empresa_id`),
  KEY `fk_conta_cliente` (`cliente_id`),
  KEY `idx_tipo` (`tipo`),
  KEY `idx_status` (`status`),
  KEY `idx_vencimento` (`data_vencimento`),
  CONSTRAINT `fk_conta_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_conta_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ====================================
-- TABELA: contratos_modelos
-- ====================================
CREATE TABLE IF NOT EXISTS `contratos_modelos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empresa_id` int(11) NOT NULL,
  `nome` varchar(200) NOT NULL,
  `descricao` text DEFAULT NULL,
  `conteudo_html` longtext NOT NULL,
  `tags` json DEFAULT NULL,
  `ativo` tinyint(1) DEFAULT 1,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_modelo_empresa` (`empresa_id`),
  CONSTRAINT `fk_modelo_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir modelo de contrato exemplo
INSERT INTO `contratos_modelos` (`empresa_id`, `nome`, `descricao`, `conteudo_html`, `tags`) VALUES
(1, 'Contrato de Prestação de Serviços', 'Modelo básico de contrato de prestação de serviços', 
'<div style="font-family: Arial, sans-serif; padding: 40px; max-width: 800px; margin: 0 auto;">
    <h1 style="text-align: center; color: #2c3e50;">CONTRATO DE PRESTAÇÃO DE SERVIÇOS</h1>
    <br>
    <p><strong>CONTRATANTE:</strong> {{nome}}</p>
    <p><strong>CPF/CNPJ:</strong> {{cpf_cnpj}}</p>
    <p><strong>Endereço:</strong> {{endereco}}, {{cidade}} - {{estado}}</p>
    <p><strong>Telefone:</strong> {{telefone}}</p>
    <p><strong>E-mail:</strong> {{email}}</p>
    <br>
    <p><strong>CONTRATADA:</strong> Empresa Demo</p>
    <br>
    <h3>OBJETO DO CONTRATO</h3>
    <p>{{descricao_servico}}</p>
    <br>
    <h3>VALOR</h3>
    <p>O valor total do serviço é de <strong>R$ {{valor}}</strong></p>
    <br>
    <h3>PRAZO</h3>
    <p>Este contrato tem validade até {{data_validade}}</p>
    <br>
    <p style="text-align: right;">{{cidade}}, {{data_atual}}</p>
    <br><br>
    <div style="display: flex; justify-content: space-between; margin-top: 80px;">
        <div style="text-align: center; width: 45%;">
            <div style="border-top: 1px solid #000; padding-top: 5px;">
                <strong>CONTRATANTE</strong><br>
                {{nome}}
            </div>
        </div>
        <div style="text-align: center; width: 45%;">
            <div style="border-top: 1px solid #000; padding-top: 5px;">
                <strong>CONTRATADA</strong><br>
                Empresa Demo
            </div>
        </div>
    </div>
</div>',
'["{{nome}}", "{{cpf_cnpj}}", "{{endereco}}", "{{cidade}}", "{{estado}}", "{{telefone}}", "{{email}}", "{{valor}}", "{{descricao_servico}}", "{{data_validade}}", "{{data_atual}}"]');

-- ====================================
-- TABELA: contratos_gerados
-- ====================================
CREATE TABLE IF NOT EXISTS `contratos_gerados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empresa_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `modelo_id` int(11) DEFAULT NULL,
  `conteudo_final` longtext NOT NULL,
  `pdf_path` varchar(255) DEFAULT NULL,
  `dados_extras` json DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_contrato_empresa` (`empresa_id`),
  KEY `fk_contrato_cliente` (`cliente_id`),
  KEY `fk_contrato_modelo` (`modelo_id`),
  CONSTRAINT `fk_contrato_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_contrato_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_contrato_modelo` FOREIGN KEY (`modelo_id`) REFERENCES `contratos_modelos` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

COMMIT;
