<?php
require_once __DIR__ . '/../config/config.php';
$pageTitle = 'Categorias';
include __DIR__ . '/includes/header.php';
include __DIR__ . '/includes/sidebar.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-tags"></i> Categorias Financeiras</h2>
        <button class="btn btn-primary" onclick="novaCategoria()"><i class="fas fa-plus"></i> Nova Categoria</button>
    </div>
    
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>Nome</th>
                    <th>Tipo</th>
                    <th>Cor</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody id="tabelaCategorias">
                <tr><td colspan="4" class="text-center">Carregando...</td></tr>
            </tbody>
        </table>
    </div>
</div>

<div class="modal" id="modalCategoria">
    <div class="modal-content">
        <div class="modal-header">
            <h5 id="modalTitulo">Nova Categoria</h5>
            <button class="close" onclick="fecharModal()">&times;</button>
        </div>
        <div class="modal-body">
            <form id="formCategoria">
                <input type="hidden" id="categoriaId">
                <div class="form-group">
                    <label class="form-label">Nome *</label>
                    <input type="text" class="form-control" id="nome" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Tipo *</label>
                    <select class="form-control" id="tipo" required>
                        <option value="entrada">Entrada</option>
                        <option value="saida">Saída</option>
                        <option value="ambos">Ambos</option>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">Cor</label>
                    <input type="color" class="form-control" id="cor" value="#3498db">
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" onclick="fecharModal()">Cancelar</button>
            <button class="btn btn-primary" onclick="salvarCategoria()">Salvar</button>
        </div>
    </div>
</div>

<script>
async function carregarCategorias() {
    try {
        const response = await fetch(`${API_URL}/categorias/index.php`);
        const data = await response.json();
        const tbody = document.getElementById('tabelaCategorias');
        
        if (data.success && data.data.length > 0) {
            tbody.innerHTML = data.data.map(cat => `
                <tr>
                    <td>${cat.nome}</td>
                    <td><span class="badge badge-${cat.tipo === 'entrada' ? 'success' : cat.tipo === 'saida' ? 'danger' : 'primary'}">${cat.tipo}</span></td>
                    <td><span style="display:inline-block;width:30px;height:30px;background:${cat.cor};border-radius:5px;"></span></td>
                    <td>
                        <button class="btn btn-sm btn-primary" onclick="editarCategoria(${cat.id})"><i class="fas fa-edit"></i></button>
                        <button class="btn btn-sm btn-danger" onclick="deletarCategoria(${cat.id})"><i class="fas fa-trash"></i></button>
                    </td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="4" class="text-center">Nenhuma categoria encontrada</td></tr>';
        }
    } catch (error) {
        console.error('Erro:', error);
        showAlert('Erro ao carregar categorias', 'danger');
    }
}

function novaCategoria() {
    document.getElementById('formCategoria').reset();
    document.getElementById('categoriaId').value = '';
    document.getElementById('modalTitulo').textContent = 'Nova Categoria';
    document.getElementById('modalCategoria').classList.add('show');
}

async function editarCategoria(id) {
    try {
        const response = await fetch(`${API_URL}/categorias/index.php`);
        const data = await response.json();
        const cat = data.data.find(c => c.id == id);
        
        if (cat) {
            document.getElementById('categoriaId').value = cat.id;
            document.getElementById('nome').value = cat.nome;
            document.getElementById('tipo').value = cat.tipo;
            document.getElementById('cor').value = cat.cor;
            document.getElementById('modalTitulo').textContent = 'Editar Categoria';
            document.getElementById('modalCategoria').classList.add('show');
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

async function salvarCategoria() {
    const id = document.getElementById('categoriaId').value;
    const dados = {
        nome: document.getElementById('nome').value,
        tipo: document.getElementById('tipo').value,
        cor: document.getElementById('cor').value
    };
    
    try {
        const url = id ? `${API_URL}/categorias/index.php?id=${id}` : `${API_URL}/categorias/index.php`;
        const method = id ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
            method: method,
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(dados)
        });
        
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            fecharModal();
            carregarCategorias();
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        console.error('Erro:', error);
        showAlert('Erro ao salvar', 'danger');
    }
}

async function deletarCategoria(id) {
    if (!confirmAction('Deseja deletar esta categoria?')) return;
    
    try {
        const response = await fetch(`${API_URL}/categorias/index.php?id=${id}`, { method: 'DELETE' });
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            carregarCategorias();
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

function fecharModal() {
    document.getElementById('modalCategoria').classList.remove('show');
}

document.addEventListener('DOMContentLoaded', carregarCategorias);
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
