<?php
require_once __DIR__ . '/../config/config.php';
$pageTitle = 'Contas';
include __DIR__ . '/includes/header.php';
include __DIR__ . '/includes/sidebar.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-file-invoice-dollar"></i> Contas a Pagar/Receber</h2>
        <button class="btn btn-primary" onclick="novaConta()"><i class="fas fa-plus"></i> Nova Conta</button>
    </div>
    
    <ul class="nav nav-tabs mb-3" id="contasTabs">
        <li class="nav-item">
            <a class="nav-link active" onclick="filtrarPorTipo('receber')">Contas a Receber</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" onclick="filtrarPorTipo('pagar')">Contas a Pagar</a>
        </li>
    </ul>
    
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>Descrição</th>
                    <th>Valor</th>
                    <th>Vencimento</th>
                    <th>Status</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody id="tabelaContas">
                <tr><td colspan="5" class="text-center">Carregando...</td></tr>
            </tbody>
        </table>
    </div>
</div>

<div class="modal" id="modalConta">
    <div class="modal-content">
        <div class="modal-header">
            <h5 id="modalTitulo">Nova Conta</h5>
            <button class="close" onclick="fecharModal()">&times;</button>
        </div>
        <div class="modal-body">
            <form id="formConta">
                <input type="hidden" id="contaId">
                <div class="form-group">
                    <label class="form-label">Tipo *</label>
                    <select class="form-control" id="tipo" required>
                        <option value="receber">A Receber</option>
                        <option value="pagar">A Pagar</option>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">Descrição *</label>
                    <input type="text" class="form-control" id="descricao" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Valor *</label>
                    <input type="number" step="0.01" class="form-control" id="valor" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Data de Vencimento *</label>
                    <input type="date" class="form-control" id="data_vencimento" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Status</label>
                    <select class="form-control" id="status">
                        <option value="pendente">Pendente</option>
                        <option value="pago">Pago</option>
                        <option value="atrasado">Atrasado</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" onclick="fecharModal()">Cancelar</button>
            <button class="btn btn-primary" onclick="salvarConta()">Salvar</button>
        </div>
    </div>
</div>

<script>
let tipoAtual = 'receber';

async function carregarContas() {
    try {
        const response = await fetch(`${API_URL}/contas/index.php?tipo=${tipoAtual}`);
        const data = await response.json();
        const tbody = document.getElementById('tabelaContas');
        
        if (data.success && data.data.length > 0) {
            tbody.innerHTML = data.data.map(conta => `
                <tr>
                    <td>${conta.descricao}</td>
                    <td>${formatCurrency(conta.valor)}</td>
                    <td>${formatDate(conta.data_vencimento)}</td>
                    <td><span class="badge badge-${conta.status === 'pago' ? 'success' : conta.status === 'atrasado' ? 'danger' : 'warning'}">${conta.status}</span></td>
                    <td>
                        <button class="btn btn-sm btn-primary" onclick="editarConta(${conta.id})"><i class="fas fa-edit"></i></button>
                        <button class="btn btn-sm btn-danger" onclick="deletarConta(${conta.id})"><i class="fas fa-trash"></i></button>
                    </td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="5" class="text-center">Nenhuma conta encontrada</td></tr>';
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

function filtrarPorTipo(tipo) {
    tipoAtual = tipo;
    document.querySelectorAll('.nav-link').forEach(el => el.classList.remove('active'));
    event.target.classList.add('active');
    carregarContas();
}

function novaConta() {
    document.getElementById('formConta').reset();
    document.getElementById('contaId').value = '';
    document.getElementById('tipo').value = tipoAtual;
    document.getElementById('modalTitulo').textContent = 'Nova Conta';
    document.getElementById('modalConta').classList.add('show');
}

async function editarConta(id) {
    try {
        const response = await fetch(`${API_URL}/contas/index.php`);
        const data = await response.json();
        const conta = data.data.find(c => c.id == id);
        
        if (conta) {
            document.getElementById('contaId').value = conta.id;
            document.getElementById('tipo').value = conta.tipo;
            document.getElementById('descricao').value = conta.descricao;
            document.getElementById('valor').value = conta.valor;
            document.getElementById('data_vencimento').value = conta.data_vencimento;
            document.getElementById('status').value = conta.status;
            document.getElementById('modalTitulo').textContent = 'Editar Conta';
            document.getElementById('modalConta').classList.add('show');
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

async function salvarConta() {
    const id = document.getElementById('contaId').value;
    const dados = {
        tipo: document.getElementById('tipo').value,
        descricao: document.getElementById('descricao').value,
        valor: parseFloat(document.getElementById('valor').value),
        data_vencimento: document.getElementById('data_vencimento').value,
        status: document.getElementById('status').value
    };
    
    try {
        const url = id ? `${API_URL}/contas/index.php?id=${id}` : `${API_URL}/contas/index.php`;
        const method = id ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
            method: method,
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(dados)
        });
        
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            fecharModal();
            carregarContas();
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

async function deletarConta(id) {
    if (!confirmAction('Deseja deletar esta conta?')) return;
    
    try {
        const response = await fetch(`${API_URL}/contas/index.php?id=${id}`, { method: 'DELETE' });
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            carregarContas();
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

function fecharModal() {
    document.getElementById('modalConta').classList.remove('show');
}

document.addEventListener('DOMContentLoaded', carregarContas);
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
