<?php
/**
 * MAXEDR10 - MAX ERP 10
 * Dashboard
 */

require_once __DIR__ . '/../config/config.php';

$pageTitle = 'Dashboard';
include __DIR__ . '/includes/header.php';
include __DIR__ . '/includes/sidebar.php';
?>

<div class="container-fluid">
    <h2 class="mb-4"><i class="fas fa-tachometer-alt"></i> Dashboard</h2>
    
    <!-- Cards de Resumo -->
    <div class="row mb-4">
        <div class="col-md-4 mb-3">
            <div class="stats-card" style="background: linear-gradient(135deg, #28a745, #20c997);">
                <p>Entradas do Mês</p>
                <h3 id="totalEntradas">R$ 0,00</h3>
            </div>
        </div>
        
        <div class="col-md-4 mb-3">
            <div class="stats-card" style="background: linear-gradient(135deg, #dc3545, #c82333);">
                <p>Saídas do Mês</p>
                <h3 id="totalSaidas">R$ 0,00</h3>
            </div>
        </div>
        
        <div class="col-md-4 mb-3">
            <div class="stats-card" id="saldoCard">
                <p>Saldo do Mês</p>
                <h3 id="saldoMes">R$ 0,00</h3>
            </div>
        </div>
    </div>
    
    <!-- Gráfico de Faturamento -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-chart-line"></i> Faturamento dos Últimos 12 Meses
                </div>
                <div class="card-body">
                    <canvas id="faturamentoChart" style="max-height: 400px;"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Carregar dados do dashboard
    async function carregarDashboard() {
        try {
            const response = await fetch(`${API_URL}/dashboard/resumo.php`);
            const data = await response.json();
            
            if (data.success) {
                // Atualizar cards
                document.getElementById('totalEntradas').textContent = formatCurrency(data.resumo_mes.entradas);
                document.getElementById('totalSaidas').textContent = formatCurrency(data.resumo_mes.saidas);
                document.getElementById('saldoMes').textContent = formatCurrency(data.resumo_mes.saldo);
                
                // Atualizar cor do card de saldo
                const saldoCard = document.getElementById('saldoCard');
                if (data.resumo_mes.saldo >= 0) {
                    saldoCard.style.background = 'linear-gradient(135deg, #4a90e2, #357abd)';
                } else {
                    saldoCard.style.background = 'linear-gradient(135deg, #dc3545, #c82333)';
                }
                
                // Criar gráfico
                criarGrafico(data.grafico);
            }
        } catch (error) {
            console.error('Erro ao carregar dashboard:', error);
            showAlert('Erro ao carregar dados do dashboard', 'danger');
        }
    }
    
    // Criar gráfico de faturamento
    function criarGrafico(dadosGrafico) {
        const ctx = document.getElementById('faturamentoChart').getContext('2d');
        
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: dadosGrafico.meses,
                datasets: [
                    {
                        label: 'Entradas',
                        data: dadosGrafico.entradas,
                        borderColor: '#28a745',
                        backgroundColor: 'rgba(40, 167, 69, 0.1)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Saídas',
                        data: dadosGrafico.saidas,
                        borderColor: '#dc3545',
                        backgroundColor: 'rgba(220, 53, 69, 0.1)',
                        tension: 0.4,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                let label = context.dataset.label || '';
                                if (label) {
                                    label += ': ';
                                }
                                label += formatCurrency(context.parsed.y);
                                return label;
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return 'R$ ' + value.toLocaleString('pt-BR');
                            }
                        }
                    }
                }
            }
        });
    }
    
    // Carregar ao iniciar
    document.addEventListener('DOMContentLoaded', carregarDashboard);
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
