<?php
/**
 * MAXEDR10 - MAX ERP 10
 * Model: Categoria
 */

namespace Maxedr10\Models;

use Maxedr10\Database\Database;

class Categoria {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    /**
     * Lista todas as categorias de uma empresa
     */
    public function listar($empresaId, $tipo = null) {
        $sql = "SELECT * FROM categorias_financeiras WHERE empresa_id = ? AND ativo = 1";
        $params = [$empresaId];
        
        if ($tipo) {
            $sql .= " AND (tipo = ? OR tipo = 'ambos')";
            $params[] = $tipo;
        }
        
        $sql .= " ORDER BY nome";
        
        return $this->db->query($sql, $params);
    }
    
    /**
     * Busca uma categoria por ID
     */
    public function buscarPorId($id, $empresaId) {
        $sql = "SELECT * FROM categorias_financeiras WHERE id = ? AND empresa_id = ?";
        return $this->db->queryOne($sql, [$id, $empresaId]);
    }
    
    /**
     * Cria uma nova categoria
     */
    public function criar($dados) {
        $sql = "INSERT INTO categorias_financeiras (
                    empresa_id, nome, tipo, cor
                ) VALUES (?, ?, ?, ?)";
        
        $params = [
            $dados['empresa_id'],
            $dados['nome'],
            $dados['tipo'] ?? 'ambos',
            $dados['cor'] ?? '#3498db'
        ];
        
        if ($this->db->execute($sql, $params)) {
            return $this->db->lastInsertId();
        }
        
        return false;
    }
    
    /**
     * Atualiza uma categoria
     */
    public function atualizar($id, $empresaId, $dados) {
        $sql = "UPDATE categorias_financeiras SET
                    nome = ?, tipo = ?, cor = ?
                WHERE id = ? AND empresa_id = ?";
        
        $params = [
            $dados['nome'],
            $dados['tipo'] ?? 'ambos',
            $dados['cor'] ?? '#3498db',
            $id,
            $empresaId
        ];
        
        return $this->db->execute($sql, $params);
    }
    
    /**
     * Deleta uma categoria (soft delete)
     */
    public function deletar($id, $empresaId) {
        $sql = "UPDATE categorias_financeiras SET ativo = 0 WHERE id = ? AND empresa_id = ?";
        return $this->db->execute($sql, [$id, $empresaId]);
    }
}
